
/* Copyright (C) 2001-2007 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* fs_radecomp.c */


#include "fs_itype.h"

#if defined(FS_ACT3)

/*
 * Returns a pointer to the requested data.
 * The caller sets *length to the requested length, and if we return more
 * then we reset *length to the actual length.
 */
#ifdef BYTE_CACHE_INTERVAL /* VL - 4/09/03 */
FS_BYTE *MTX_RA_GetFragmentPtr(_DS_ MTX_RA_DECOMP *t, FS_ULONG position, FS_ULONG *byteCountPtr )
#else
FS_BYTE *MTX_RA_GetFragmentPtr(_DS_ MTX_RA_DECOMP *t, FS_ULONG position, FS_ULONG *byteCountPtr, FS_USHORT byteCacheInterval )
#endif /* BYTE_CACHE_INTERVAL */
{
    FS_BYTE *p, *data;
    FS_ULONG i, j, byteCount = *byteCountPtr;
    FS_ULONG len; /* not a register variable since we need &len */
    FS_ULONG bitMark;

#ifdef FS_MEM_DBG
    STATE.memdbgid = "MTX_RA_GetFragmentPtr";
#endif
    data = (FS_BYTE *)FSS_calloc(_PS_ byteCount );

    if (!data )
        return NULL;

#ifdef BYTE_CACHE_INTERVAL /* VL - 4/09/03 */
    j = position / BYTE_CACHE_INTERVAL;
    i = j * BYTE_CACHE_INTERVAL - t->deltaBytes[j]; /* The current position. */
#else
    j = position / byteCacheInterval;
    i = j * byteCacheInterval - t->deltaBytes[j]; /* The current position. */
#endif /* BYTE_CACHE_INTERVAL */

    /* access bitmark[j] */
    p = &t->bitMarks[4 * j];
    bitMark = *p++;
    bitMark = (bitMark << 8) | *p++;
    bitMark = (bitMark << 8) | *p++;
    bitMark = (bitMark << 8) | *p++;

    MTX_BITIO_fseek( t->bio, bitMark );    /* Go to a position on or before "position". */

    /* gotta prime the pump for ReadSymbol() */
    t->next = MTX_BITIO_ReadValue(t->bio, TABLE_BITS);


    /* Loop until we straddle position */
    for (;; i += j)
    {
        p = ReadSymbol(_PS_ t, &len );
        j = len;
        if ( (FS_ULONG)(i + j) > position ) break; /*****/
    }

    /* Skip extra data in the beginning of the first symbol. */
    i      = position - i;
    p     += i;
    j     -= i; /* j == len */

    /* First read the remainder of the first partial symbol, and then */
    /* read all intermediate symbols and the last partial symbol. */
    for (i = 0;;)
    {
        if ( i + j < byteCount )
        {
            /* Copy the intermediate (or first) symbol. */
            do
            {
                data[i++] = *p++;
            }
            while ( --j > 0 );
        }
        else
        {
            /* Copy the last partial symbol. */
            j = byteCount - i;
            do
            {
                data[i++] = *p++;
            }
            while ( --j > 0 );
            return data; /***** DONE! *****/
        }
        p = ReadSymbol(_PS_ t, &len );
        j = len;
    }
    /* We never get here so no return is needed. */
}

#endif /* FS_ACT3 */



